/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import mlsoft.mct.MlPanel;
import mlsoft.mct.MlProgressResourceMap;
import mlsoft.mct.MlResource;
import mlsoft.mct.MlResources;
import mlsoft.mct.MlUtil;

public class MlProgress
extends MlPanel {
    public static final int METER_BAR = 0;
    public static final int METER_BOXES = 1;
    private static MlProgressResourceMap _progResMap;
    protected long _startTime;
    protected Color _bottomShadowColor;
    protected int _completeValue;
    protected int _meterStyle;
    protected int _numBoxes;
    protected int _shadowThickness;
    protected boolean _showPercentage;
    protected boolean _showTime;
    protected Color _topShadowColor;
    protected int _value;

    private static synchronized void initResourceMap() {
        if (_progResMap != null) {
            return;
        }
        _progResMap = new MlProgressResourceMap();
    }

    public MlProgress() {
        MlProgress.initResourceMap();
        this._resourceMap = _progResMap;
        this.initProgressProperties();
        this.setComponentFont(new Font("Helvetica", 1, 12));
        this.setForeground(new Color(0, 0, 180));
        this._bottomShadowColor = new Color(225, 225, 225);
        this._completeValue = 100;
        this._meterStyle = 0;
        this._numBoxes = 20;
        this._shadowThickness = 1;
        this._showPercentage = true;
        this._showTime = false;
        this._topShadowColor = new Color(60, 60, 60);
        this._value = 0;
        this._startTime = 0L;
    }

    public Dimension preferredSize() {
        return new Dimension(200, 20);
    }

    public synchronized void drawView(Graphics graphics, Rectangle rectangle) {
        int n = this._shadowThickness;
        rectangle = new Rectangle();
        rectangle.x = n;
        rectangle.y = n;
        rectangle.width = this.getBounds().width - n * 2;
        rectangle.height = this.getBounds().height - n * 2;
        if (this._meterStyle == 0) {
            this.drawBarMeter(graphics, rectangle);
        } else if (this._meterStyle == 1) {
            this.drawBoxesMeter(graphics, rectangle);
        }
        MlUtil.drawShadow(graphics, 0, 0, this.getBounds().width, this.getBounds().height, n, this._topShadowColor, this._bottomShadowColor);
    }

    protected void drawBoxesMeter(Graphics graphics, Rectangle rectangle) {
        int n = this._numBoxes;
        int n2 = this._shadowThickness;
        if (n * n2 * 2 > rectangle.width) {
            return;
        }
        int n3 = this._completeValue > 0 ? (int)((long)n * (long)this._value / (long)this._completeValue) : 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            if (n5 < n3) {
                graphics.setColor(this.getForeground());
            } else {
                graphics.setColor(this.getBackground());
            }
            int n6 = n4;
            n4 = n5 == n - 1 ? rectangle.width : rectangle.width * (n5 + 1) / n;
            graphics.fillRect(rectangle.x + n6 + n2, rectangle.y + n2, n4 - n6 - n2 * 2, rectangle.height - n2 * 2);
            MlUtil.drawShadow(graphics, rectangle.x + n6, rectangle.y, n4 - n6, rectangle.height, this._shadowThickness, this._topShadowColor, this._bottomShadowColor);
            ++n5;
        }
    }

    protected void drawBarMeter(Graphics graphics, Rectangle rectangle) {
        long l = this._completeValue > 0 ? (long)rectangle.width * (long)this._value / (long)this._completeValue : 0L;
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = rectangle.x;
        rectangle2.y = rectangle.y;
        rectangle2.width = (int)l;
        rectangle2.height = rectangle.height;
        graphics.setColor(this.getForeground());
        graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle3 = new Rectangle();
        rectangle3.x = rectangle.x + (int)l;
        rectangle3.y = rectangle.y;
        rectangle3.width = rectangle.width - (int)l;
        rectangle3.height = rectangle.height;
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        int n = this._completeValue > 0 ? (int)((long)this._value * 100L / (long)this._completeValue) : 0;
        String string = String.valueOf(n) + "%";
        Dimension dimension = this.stringExtents(graphics, this.getFont(), string);
        if (dimension == null) {
            return;
        }
        int n2 = dimension.width;
        int n3 = dimension.height;
        if (this._showPercentage) {
            this.drawString(graphics, string, rectangle.x + rectangle.width / 2 - n2 / 2, rectangle.y + rectangle.height / 2 - n3 / 2, rectangle2, rectangle3);
        }
        long l2 = System.currentTimeMillis() / 1000L;
        int n4 = (int)(l2 - this._startTime);
        if (this._showTime && this._value > 0 && this._value != this._completeValue && n4 > 0) {
            string = this.timeStr(n4);
            dimension = this.stringExtents(graphics, this.getFont(), string);
            if (dimension == null) {
                return;
            }
            n2 = dimension.width;
            n3 = dimension.height;
            this.drawString(graphics, string, rectangle.x + 5, rectangle.y + rectangle.height / 2 - n3 / 2, rectangle2, rectangle3);
        }
        int n5 = 0;
        if (n > 0) {
            n5 = n4 * 100 / n - n4;
        }
        if (this._showTime && n > 0 && n != 100 && n5 > 0) {
            string = this.timeStr(n5);
            dimension = this.stringExtents(graphics, this.getFont(), string);
            if (dimension == null) {
                return;
            }
            n2 = dimension.width;
            n3 = dimension.height;
            this.drawString(graphics, string, rectangle.x + rectangle.width - n2 - 5, rectangle.y + rectangle.height / 2 - n3 / 2, rectangle2, rectangle3);
        }
    }

    protected void drawString(Graphics graphics, String string, int n, int n2, Rectangle rectangle, Rectangle rectangle2) {
        if (this.getFont() == null || string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        if (rectangle.width > 0 && rectangle.height > 0) {
            graphics.setColor(this.getBackground());
            Graphics graphics2 = graphics.create();
            MlUtil.graphicsClipRect(graphics2, rectangle);
            graphics2.drawString(string, n, n2 + fontMetrics.getAscent());
            graphics2.dispose();
        }
        if (rectangle2.width > 0 && rectangle2.height > 0) {
            graphics.setColor(this.getForeground());
            Graphics graphics3 = graphics.create();
            MlUtil.graphicsClipRect(graphics3, rectangle2);
            graphics3.drawString(string, n, n2 + fontMetrics.getAscent());
            graphics3.dispose();
        }
    }

    protected Dimension stringExtents(Graphics graphics, Font font, String string) {
        if (font == null || string == null) {
            return null;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
    }

    protected String timeStr(int n) {
        String string = new String();
        int n2 = n;
        int n3 = n2 / 60;
        n2 -= n3 * 60;
        int n4 = n3 / 60;
        n3 -= n4 * 60;
        if (n4 > 99) {
            n4 = 99;
        }
        string = n4 > 0 && n3 < 10 ? String.valueOf(n4) + ":0" + n3 + " hr" : (n4 > 0 ? String.valueOf(n4) + ":" + n3 + " hr" : (n3 > 0 && n2 < 10 ? String.valueOf(n3) + ":0" + n2 + " min" : (n3 > 0 ? String.valueOf(n3) + ":" + n2 + " min" : String.valueOf(n2) + " sec")));
        return string;
    }

    public Object getValueByIndex(int n) {
        Object object = super.getValueByIndex(n);
        if (object != null) {
            return object;
        }
        switch (n) {
            case 4: {
                return this._bottomShadowColor;
            }
            case 5: {
                return new Integer(this._completeValue);
            }
            case 6: {
                return new Integer(this._meterStyle);
            }
            case 7: {
                return new Integer(this._numBoxes);
            }
            case 8: {
                return new Integer(this._shadowThickness);
            }
            case 9: {
                return new Boolean(this._showPercentage);
            }
            case 10: {
                return new Boolean(this._showTime);
            }
            case 11: {
                return this._topShadowColor;
            }
            case 12: {
                return new Integer(this._value);
            }
        }
        return null;
    }

    protected synchronized void setValuesConverted(MlResources mlResources) {
        super.setValuesConverted(mlResources);
        int n = mlResources.getCount();
        int n2 = 0;
        while (n2 < n) {
            MlResource mlResource = mlResources.getResource(n2);
            if (!mlResource.applied && mlResource.converted) {
                int n3 = 0;
                if (mlResource.type == 1) {
                    n3 = (Integer)mlResource.value;
                }
                boolean bl = false;
                if (mlResource.type == 3) {
                    bl = (Boolean)mlResource.value;
                }
                switch (mlResource.index) {
                    case 4: {
                        this.setBottomShadowColor((Color)mlResource.value);
                        mlResource.applied = true;
                        break;
                    }
                    case 5: {
                        this.setCompleteValue(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 6: {
                        this.setMeterStyle(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 7: {
                        this.setNumBoxes(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 8: {
                        this.setShadowThickness(n3);
                        mlResource.applied = true;
                        break;
                    }
                    case 9: {
                        this.setShowPercentage(bl);
                        mlResource.applied = true;
                        break;
                    }
                    case 10: {
                        this.setShowTime(bl);
                        mlResource.applied = true;
                        break;
                    }
                    case 11: {
                        this.setTopShadowColor((Color)mlResource.value);
                        mlResource.applied = true;
                        break;
                    }
                    case 12: {
                        this.setValue(n3);
                        mlResource.applied = true;
                    }
                }
            }
            ++n2;
        }
    }

    protected void initProgressProperties() {
        this._bottomShadowColor = new Color(225, 225, 225);
        this._completeValue = 100;
        this._meterStyle = 0;
        this._numBoxes = 20;
        this._shadowThickness = 1;
        this._showPercentage = true;
        this._showTime = false;
        this._topShadowColor = new Color(60, 60, 60);
        this._value = 0;
    }

    public void setBottomShadowColor(Color color) {
        this._bottomShadowColor = color;
        this.draw();
    }

    public Color getBottomShadowColor() {
        return this._bottomShadowColor;
    }

    public void setCompleteValue(int n) {
        if (n < 1) {
            this.warning("can't set completeValue < 1");
            return;
        }
        this._completeValue = n;
        this.draw();
    }

    public int getCompleteValue() {
        return this._completeValue;
    }

    public void setMeterStyle(int n) {
        this._meterStyle = n;
        this.draw();
    }

    public int getMeterStyle() {
        return this._meterStyle;
    }

    public void setNumBoxes(int n) {
        if (n < 1) {
            this.warning("can't set numBoxes < 1");
            return;
        }
        this._numBoxes = n;
        this.draw();
    }

    public int getNumBoxes() {
        return this._numBoxes;
    }

    public void setShadowThickness(int n) {
        this._shadowThickness = n;
        this.draw();
    }

    public int getShadowThickness() {
        return this._shadowThickness;
    }

    public void setShowPercentage(boolean bl) {
        this._showPercentage = bl;
        this.draw();
    }

    public boolean getShowPercentage() {
        return this._showPercentage;
    }

    public void setShowTime(boolean bl) {
        this._showTime = bl;
        this.draw();
    }

    public boolean getShowTime() {
        return this._showTime;
    }

    public void setTopShadowColor(Color color) {
        this._topShadowColor = color;
        this.draw();
    }

    public Color getTopShadowColor() {
        return this._topShadowColor;
    }

    public synchronized void setValue(int n) {
        if (n < 0) {
            this.warning("can't set value < 0");
            return;
        }
        if (n > this._completeValue) {
            this.warning("can't set value > completeValue");
            return;
        }
        this._value = n;
        if (this._value == 0) {
            this._startTime = System.currentTimeMillis() / 1000L;
        }
        this.draw();
    }

    public int getValue() {
        return this._value;
    }

    public void updateDisplay() {
        if (!this.isShowing()) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
        graphics.dispose();
    }
}

